<?php

$currentDir = isset($_GET['path']) ? urldecode($_GET['path']) : __DIR__;


$parentDir = dirname($currentDir);


function getFileSize($file) {
    return filesize($file);
}

function getFileUploadTime($file) {
    return date("Y-m-d H:i:s", filemtime($file));
}


$directories = [];
$files = [];
foreach (scandir($currentDir) as $item) {
    $filePath = $currentDir . DIRECTORY_SEPARATOR . $item;
    if ($item !== '.' && $item !== '..') {
        if (is_dir($filePath)) {
            $directories[] = $item;
        } else {
            $files[] = $item;
        }
    }
}


$sortedItems = array_merge($directories, $files);


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'download') {
    $files = json_decode($_POST['files']);
    foreach ($files as $file) {
        if (file_exists($file)) {
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename="' . basename($file) . '"');
            header('Content-Length: ' . filesize($file));
            readfile($file);
            exit;
        }
    }
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'zip') {
    $files = json_decode($_POST['files']);
    $zip = new ZipArchive();
    $zipFileName = 'files_' . time() . '.zip';
    if ($zip->open($zipFileName, ZipArchive::CREATE) === TRUE) {
        foreach ($files as $file) {
            if (file_exists($file)) {
                $zip->addFile($file, basename($file));
            }
        }
        $zip->close();
        echo json_encode(['message' => 'Zip created successfully', 'zip' => $zipFileName]);
    } else {
        echo json_encode(['message' => 'Failed to create zip']);
    }
    exit;
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'upload') {
    if (isset($_FILES['file'])) {
        $uploadDir = $currentDir . DIRECTORY_SEPARATOR;
        $uploadFile = $uploadDir . basename($_FILES['file']['name']);
        if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadFile)) {
            echo json_encode(['message' => 'File uploaded successfully']);
        } else {
            echo json_encode(['message' => 'Failed to upload file']);
        }
    }
    exit;
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'delete') {
    $files = json_decode($_POST['files']);
    foreach ($files as $file) {
        if (file_exists($file)) {
            unlink($file);
        }
    }
    echo json_encode(['message' => 'Files deleted successfully']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Manager</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f9;
        }
        .container {
            width: 90%;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f8f8f8;
        }
        .actions {
            margin-top: 20px;
            display: flex;
            gap: 10px;
        }
        .actions button {
            padding: 10px;
            border: none;
            background: #007bff;
            color: white;
            border-radius: 5px;
            cursor: pointer;
        }
        .actions button:hover {
            background: #0056b3;
        }
        .back-button {
            margin-bottom: 10px;
            display: inline-block;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>File Manager</h2>

    
    <?php if ($currentDir !== $homeDir): ?>
        <a href="?path=<?= urlencode($parentDir) ?>" class="back-button">
            <button>Back to Parent Directory</button>
        </a>
    <?php endif; ?>

    <table>
        <thead>
        <tr>
            <th>Select</th>
            <th>Name</th>
            <th>Size</th>
            <th>Last Modified</th>
        </tr>
        </thead>
        <tbody>
        <?php
        foreach ($sortedItems as $item):
            $filePath = $currentDir . DIRECTORY_SEPARATOR . $item;
            $size = is_dir($filePath) ? '-' : getFileSize($filePath) . ' bytes';
            $lastModified = getFileUploadTime($filePath);
            ?>
            <tr>
                <td><input type="checkbox" value="<?= $filePath ?>"></td>
                <td>
                    <?php if (is_dir($filePath)): ?>
                        <a href="?path=<?= urlencode($filePath) ?>"><?= $item ?>/</a>
                    <?php else: ?>
                        <?= $item ?>
                    <?php endif; ?>
                </td>
                <td><?= $size ?></td>
                <td><?= $lastModified ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div class="actions">
        <button onclick="selectAll()">Select All</button>
        <button onclick="deleteFiles()">Delete</button>
        <button onclick="downloadFiles()">Download</button>
        <button onclick="zipFiles()">Create Zip</button>
        <button onclick="previewFile()">Preview</button>
        <input type="file" id="uploadFile" style="display:none" onchange="uploadFile()">
        <button onclick="document.getElementById('uploadFile').click()">Upload</button>
        <button onclick="renameFile()">Rename</button>
        <button onclick="window.location.href='/phpmyadmin/'">Access phpMyAdmin</button>
    </div>
</div>
<script>
    function selectAll() {
        document.querySelectorAll('input[type="checkbox"]').forEach(cb => cb.checked = true);
    }

    function deleteFiles() {
        const files = getSelectedFiles();
        if (files.length > 0 && confirm('Are you sure you want to delete the selected files?')) {
            fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: `action=delete&files=${encodeURIComponent(JSON.stringify(files))}`
            }).then(res => res.json()).then(data => {
                alert(data.message);
                location.reload();
            });
        } else {
            alert('No files selected.');
        }
    }

    function downloadFiles() {
        const files = getSelectedFiles();
        if (files.length > 0) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.style.display = 'none';
            form.innerHTML = `
                <input type="hidden" name="action" value="download">
                <input type="hidden" name="files" value='${JSON.stringify(files)}'>
            `;
            document.body.appendChild(form);
            form.submit();
        } else {
            alert('No files selected.');
        }
    }

    function zipFiles() {
        const files = getSelectedFiles();
        if (files.length > 0) {
            fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: `action=zip&files=${encodeURIComponent(JSON.stringify(files))}`
            }).then(res => res.json()).then(data => {
                alert(data.message);
                if (data.zip) {
                    window.location.href = data.zip;
                }
            });
        } else {
            alert('No files selected.');
        }
    }

    function previewFile() {
        const files = getSelectedFiles();
        if (files.length === 1) {
            window.open(`?action=preview&file=${encodeURIComponent(files[0])}`, '_blank');
        } else {
            alert('Please select only one file for preview.');
        }
    }

    function uploadFile() {
        const fileInput = document.getElementById('uploadFile');
        const formData = new FormData();
        formData.append('action', 'upload');
        formData.append('file', fileInput.files[0]);

        fetch('', {
            method: 'POST',
            body: formData
        }).then(res => res.json()).then(data => {
            alert(data.message);
            location.reload();
        });
    }

    function renameFile() {
        const files = getSelectedFiles();
        if (files.length === 1) {
            const newName = prompt('Enter new name:');
            if (newName) {
                fetch('', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: `action=rename&oldName=${encodeURIComponent(files[0])}&newName=${encodeURIComponent(newName)}`
                }).then(res => res.json()).then(data => {
                    alert(data.message);
                    location.reload();
                });
            }
        } else {
            alert('Please select only one file to rename.');
        }
    }

    function getSelectedFiles() {
        return Array.from(document.querySelectorAll('input[type="checkbox"]:checked')).map(cb => cb.value);
    }
</script>
</body>
</html>